/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.transport;

import cofh.api.transport.IEnderAttuned;
import cofh.api.transport.IEnderDestination;
import cofh.api.transport.IEnderEnergyHandler;
import cofh.api.transport.IEnderFluidHandler;
import cofh.api.transport.IEnderItemHandler;
import cofh.lib.util.ArrayHashList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class EnderRegistry {
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderItemHandler>>> inputItem = new HashMap();
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderFluidHandler>>> inputFluid = new HashMap();
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderEnergyHandler>>> inputEnergy = new HashMap();
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderItemHandler>>> outputItem = new HashMap();
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderFluidHandler>>> outputFluid = new HashMap();
    private HashMap<String, TIntObjectHashMap<ArrayHashList<IEnderEnergyHandler>>> outputEnergy = new HashMap();
    private HashMap<String, TIntObjectHashMap<EnderDestination>> outputTeleport = new HashMap();
    private HashMap<String, BitSet> usedTeleports = new HashMap();
    private Configuration linkConf;

    public EnderRegistry(Configuration configuration) {
        this.linkConf = configuration;
        this.load();
    }

    private void load() {
        for (String string : this.linkConf.getCategoryNames()) {
            ConfigCategory configCategory = this.linkConf.getCategory(string);
            TIntObjectHashMap tIntObjectHashMap = this.outputTeleport.get(string);
            BitSet bitSet = this.usedTeleports.get(string);
            if (tIntObjectHashMap == null) {
                tIntObjectHashMap = new TIntObjectHashMap();
                this.outputTeleport.put(string, (TIntObjectHashMap<EnderDestination>)tIntObjectHashMap);
                bitSet = new BitSet();
                this.usedTeleports.put(string, bitSet);
            }
            for (Property property : configCategory.values()) {
                try {
                    int n = Integer.parseInt(property.getName());
                    String[] stringArray = property.getString().split("@");
                    if (stringArray.length != 2) continue;
                    int n2 = Integer.parseInt(stringArray[0]);
                    if ((stringArray = stringArray[1].split(",")).length != 3) continue;
                    int n3 = Integer.parseInt(stringArray[0]);
                    int n4 = Integer.parseInt(stringArray[1]);
                    int n5 = Integer.parseInt(stringArray[2]);
                    EnderDestination enderDestination = new EnderDestination(n3, n4, n5, n2);
                    tIntObjectHashMap.put(n, (Object)enderDestination);
                    bitSet.set(n);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void save() {
        if (this.linkConf.hasChanged()) {
            this.linkConf.save();
        }
    }

    private <T> T getElement(HashMap<String, TIntObjectHashMap<T>> hashMap, IEnderAttuned iEnderAttuned) {
        TIntObjectHashMap<T> tIntObjectHashMap = hashMap.get(iEnderAttuned.getChannelString());
        if (tIntObjectHashMap != null) {
            return (T)tIntObjectHashMap.get(iEnderAttuned.getFrequency());
        }
        return null;
    }

    public List<IEnderItemHandler> getLinkedItemInputs(IEnderItemHandler iEnderItemHandler) {
        return (List)this.getElement(this.inputItem, iEnderItemHandler);
    }

    public List<IEnderItemHandler> getLinkedItemOutputs(IEnderItemHandler iEnderItemHandler) {
        return (List)this.getElement(this.outputItem, iEnderItemHandler);
    }

    public List<IEnderFluidHandler> getLinkedFluidInputs(IEnderFluidHandler iEnderFluidHandler) {
        return (List)this.getElement(this.inputFluid, iEnderFluidHandler);
    }

    public List<IEnderFluidHandler> getLinkedFluidOutputs(IEnderFluidHandler iEnderFluidHandler) {
        return (List)this.getElement(this.outputFluid, iEnderFluidHandler);
    }

    public List<IEnderEnergyHandler> getLinkedEnergyInputs(IEnderEnergyHandler iEnderEnergyHandler) {
        return (List)this.getElement(this.inputEnergy, iEnderEnergyHandler);
    }

    public List<IEnderEnergyHandler> getLinkedEnergyOutputs(IEnderEnergyHandler iEnderEnergyHandler) {
        return (List)this.getElement(this.outputEnergy, iEnderEnergyHandler);
    }

    public int findFreeFrequency(String string) {
        BitSet bitSet = this.usedTeleports.get(string);
        if (bitSet == null) {
            return 0;
        }
        return bitSet.nextClearBit(0);
    }

    public boolean hasDestination(IEnderDestination iEnderDestination) {
        return this.hasDestination(iEnderDestination, true);
    }

    public boolean hasDestination(IEnderDestination iEnderDestination, boolean bl) {
        String string = iEnderDestination.getChannelString();
        TIntObjectHashMap<EnderDestination> tIntObjectHashMap = this.outputTeleport.get(string);
        if (tIntObjectHashMap == null) {
            return false;
        }
        int n = bl ? iEnderDestination.getDestination() : iEnderDestination.getFrequency();
        EnderDestination enderDestination = (EnderDestination)tIntObjectHashMap.get(n);
        boolean bl2 = enderDestination == null ? false : enderDestination.hasOutput();
        this.usedTeleports.get(string).set(n, bl2);
        return bl2;
    }

    public IEnderDestination getDestination(IEnderDestination iEnderDestination) {
        return this.getDestination(iEnderDestination, true);
    }

    public IEnderDestination getDestination(IEnderDestination iEnderDestination, boolean bl) {
        final String string = iEnderDestination.getChannelString();
        TIntObjectHashMap<EnderDestination> tIntObjectHashMap = this.outputTeleport.get(string);
        if (tIntObjectHashMap == null) {
            return null;
        }
        final int n = iEnderDestination.getDestination();
        final EnderDestination enderDestination = (EnderDestination)tIntObjectHashMap.get(n);
        if (enderDestination == null) {
            return null;
        }
        IEnderDestination iEnderDestination2 = enderDestination.getOutput(bl);
        if (bl && iEnderDestination2 == null && !enderDestination.isInvalid) {
            return new IEnderDestination(){

                @Override
                public String getChannelString() {
                    return string;
                }

                @Override
                public int getFrequency() {
                    return n;
                }

                @Override
                public boolean setFrequency(int n2) {
                    return false;
                }

                @Override
                public boolean clearFrequency() {
                    return false;
                }

                @Override
                public boolean isNotValid() {
                    return true;
                }

                @Override
                public int x() {
                    return enderDestination.x;
                }

                @Override
                public int y() {
                    return enderDestination.y;
                }

                @Override
                public int z() {
                    return enderDestination.z;
                }

                @Override
                public int dimension() {
                    return enderDestination.dimension;
                }

                @Override
                public int getDestination() {
                    return -1;
                }

                @Override
                public boolean setDestination(int n2) {
                    return false;
                }

                @Override
                public boolean clearDestination() {
                    return false;
                }
            };
        }
        return iEnderDestination2;
    }

    private <T extends IEnderAttuned> boolean addHandler(HashMap<String, TIntObjectHashMap<ArrayHashList<T>>> hashMap, T t) {
        int n;
        ArrayHashList<T> arrayHashList;
        String string = t.getChannelString();
        TIntObjectHashMap tIntObjectHashMap = hashMap.get(string);
        if (tIntObjectHashMap == null) {
            tIntObjectHashMap = new TIntObjectHashMap();
            hashMap.put(string, tIntObjectHashMap);
        }
        if ((arrayHashList = (ArrayHashList<T>)tIntObjectHashMap.get(n = t.getFrequency())) == null) {
            arrayHashList = new ArrayHashList<T>();
            tIntObjectHashMap.put(n, arrayHashList);
        }
        return arrayHashList.add(t);
    }

    public void addItemHandler(IEnderItemHandler iEnderItemHandler) {
        if (iEnderItemHandler.canSendItems()) {
            this.addHandler(this.inputItem, iEnderItemHandler);
        }
        if (iEnderItemHandler.canReceiveItems()) {
            this.addHandler(this.outputItem, iEnderItemHandler);
        }
    }

    public void addFluidHandler(IEnderFluidHandler iEnderFluidHandler) {
        if (iEnderFluidHandler.canSendFluid()) {
            this.addHandler(this.inputFluid, iEnderFluidHandler);
        }
        if (iEnderFluidHandler.canReceiveFluid()) {
            this.addHandler(this.outputFluid, iEnderFluidHandler);
        }
    }

    public void addEnergyHandler(IEnderEnergyHandler iEnderEnergyHandler) {
        if (iEnderEnergyHandler.canSendEnergy()) {
            this.addHandler(this.inputEnergy, iEnderEnergyHandler);
        }
        if (iEnderEnergyHandler.canReceiveEnergy()) {
            this.addHandler(this.outputEnergy, iEnderEnergyHandler);
        }
    }

    public void addDestination(IEnderDestination iEnderDestination) {
        if (!this.hasDestination(iEnderDestination, false)) {
            String string = iEnderDestination.getChannelString();
            TIntObjectHashMap tIntObjectHashMap = this.outputTeleport.get(string);
            BitSet bitSet = this.usedTeleports.get(string);
            if (tIntObjectHashMap == null) {
                tIntObjectHashMap = new TIntObjectHashMap();
                this.outputTeleport.put(string, (TIntObjectHashMap<EnderDestination>)tIntObjectHashMap);
                bitSet = new BitSet();
                this.usedTeleports.put(string, bitSet);
            }
            int n = iEnderDestination.getFrequency();
            EnderDestination enderDestination = new EnderDestination(iEnderDestination);
            tIntObjectHashMap.put(n, (Object)enderDestination);
            bitSet.set(n);
            this.linkConf.get(string, String.valueOf(n), "").set(enderDestination.toString());
        }
    }

    private <T> boolean removeHandler(HashMap<String, TIntObjectHashMap<ArrayHashList<T>>> hashMap, IEnderAttuned iEnderAttuned) {
        TIntObjectHashMap<ArrayHashList<T>> tIntObjectHashMap = hashMap.get(iEnderAttuned.getChannelString());
        if (tIntObjectHashMap == null) {
            return false;
        }
        ArrayHashList arrayHashList = (ArrayHashList)tIntObjectHashMap.get(iEnderAttuned.getFrequency());
        if (arrayHashList == null) {
            return false;
        }
        return arrayHashList.remove(iEnderAttuned);
    }

    public void removeItemHandler(IEnderItemHandler iEnderItemHandler) {
        this.removeHandler(this.inputItem, iEnderItemHandler);
        this.removeHandler(this.outputItem, iEnderItemHandler);
    }

    public void removeFluidHandler(IEnderFluidHandler iEnderFluidHandler) {
        this.removeHandler(this.inputFluid, iEnderFluidHandler);
        this.removeHandler(this.outputFluid, iEnderFluidHandler);
    }

    public void removeEnergyHandler(IEnderEnergyHandler iEnderEnergyHandler) {
        this.removeHandler(this.inputEnergy, iEnderEnergyHandler);
        this.removeHandler(this.outputEnergy, iEnderEnergyHandler);
    }

    public void removeDestination(IEnderDestination iEnderDestination) {
        String string = iEnderDestination.getChannelString();
        TIntObjectHashMap<EnderDestination> tIntObjectHashMap = this.outputTeleport.get(string);
        if (tIntObjectHashMap == null) {
            return;
        }
        int n = iEnderDestination.getFrequency();
        EnderDestination enderDestination = (EnderDestination)tIntObjectHashMap.get(n);
        if (enderDestination == null) {
            return;
        }
        if (enderDestination.dimension == iEnderDestination.dimension() && enderDestination.x == iEnderDestination.x() && enderDestination.y == iEnderDestination.y() && enderDestination.z == iEnderDestination.z()) {
            tIntObjectHashMap.remove(n);
            this.usedTeleports.get(string).set(n, false);
            this.linkConf.getCategory(string).remove((Object)String.valueOf(n));
        }
    }

    public void add(IEnderAttuned iEnderAttuned) {
        if (iEnderAttuned instanceof IEnderItemHandler) {
            this.addItemHandler((IEnderItemHandler)iEnderAttuned);
        }
        if (iEnderAttuned instanceof IEnderFluidHandler) {
            this.addFluidHandler((IEnderFluidHandler)iEnderAttuned);
        }
        if (iEnderAttuned instanceof IEnderEnergyHandler) {
            this.addEnergyHandler((IEnderEnergyHandler)iEnderAttuned);
        }
        if (iEnderAttuned instanceof IEnderDestination) {
            this.addDestination((IEnderDestination)iEnderAttuned);
        }
    }

    public void remove(IEnderAttuned iEnderAttuned) {
        if (iEnderAttuned instanceof IEnderItemHandler) {
            this.removeItemHandler((IEnderItemHandler)iEnderAttuned);
        }
        if (iEnderAttuned instanceof IEnderFluidHandler) {
            this.removeFluidHandler((IEnderFluidHandler)iEnderAttuned);
        }
        if (iEnderAttuned instanceof IEnderEnergyHandler) {
            this.removeEnergyHandler((IEnderEnergyHandler)iEnderAttuned);
        }
        if (iEnderAttuned instanceof IEnderDestination) {
            this.removeDestination((IEnderDestination)iEnderAttuned);
        }
    }

    private static class EnderDestination {
        private final int dimension;
        private final int x;
        private final int y;
        private final int z;
        private IEnderDestination output;
        private boolean isInvalid;

        public EnderDestination(IEnderDestination iEnderDestination) {
            this.x = iEnderDestination.x();
            this.y = iEnderDestination.y();
            this.z = iEnderDestination.z();
            this.dimension = iEnderDestination.dimension();
            this.output = iEnderDestination;
        }

        private EnderDestination(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.z = n3;
            this.dimension = n4;
        }

        public boolean hasOutput() {
            return !this.isInvalid && DimensionManager.isDimensionRegistered((int)this.dimension);
        }

        public IEnderDestination getOutput(boolean bl) {
            if (this.output == null || this.output.isNotValid()) {
                this.output = null;
                if (!DimensionManager.isDimensionRegistered((int)this.dimension)) {
                    return null;
                }
                WorldServer worldServer = DimensionManager.getWorld((int)this.dimension);
                if (worldServer != null || bl) {
                    return null;
                }
                DimensionManager.initDimension((int)this.dimension);
                worldServer = DimensionManager.getWorld((int)this.dimension);
                if (worldServer.func_72899_e(this.x, this.y, this.z)) {
                    TileEntity tileEntity = worldServer.func_147438_o(this.x, this.y, this.z);
                    if (tileEntity instanceof IEnderDestination) {
                        this.output = (IEnderDestination)tileEntity;
                    } else {
                        this.isInvalid = true;
                    }
                }
            }
            return this.output;
        }

        public String toString() {
            return String.format("%s@%s,%s,%s", this.dimension, this.x, this.y, this.z);
        }

        public int hashCode() {
            return this.dimension ^ this.y + this.x * (this.z * 100);
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != EnderDestination.class) {
                return false;
            }
            EnderDestination enderDestination = (EnderDestination)object;
            return enderDestination.x == this.x && enderDestination.y == this.y && enderDestination.z == this.z && enderDestination.dimension == this.dimension;
        }
    }
}

